/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DetectTextRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Image").isBinary(false).build();
    private static final DetectTextRequestModelMarshaller INSTANCE = new DetectTextRequestModelMarshaller();

    private DetectTextRequestModelMarshaller() {
    }

    public static DetectTextRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DetectTextRequest detectTextRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)detectTextRequest), (String)"detectTextRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)detectTextRequest.image(), IMAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

