/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.FaceDetection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaceDetectionMarshaller {
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final FaceDetectionMarshaller INSTANCE = new FaceDetectionMarshaller();

    private FaceDetectionMarshaller() {
    }

    public static FaceDetectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FaceDetection faceDetection, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)faceDetection, (String)"faceDetection");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)faceDetection.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)faceDetection.face(), FACE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

