/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.FaceRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaceRecordMarshaller {
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACEDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceDetail").isBinary(false).build();
    private static final FaceRecordMarshaller INSTANCE = new FaceRecordMarshaller();

    private FaceRecordMarshaller() {
    }

    public static FaceRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FaceRecord faceRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)faceRecord, (String)"faceRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)faceRecord.face(), FACE_BINDING);
            protocolMarshaller.marshall((Object)faceRecord.faceDetail(), FACEDETAIL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

