/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LandmarkMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Float> X_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("X").isBinary(false).build();
    private static final MarshallingInfo<Float> Y_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Y").isBinary(false).build();
    private static final LandmarkMarshaller INSTANCE = new LandmarkMarshaller();

    private LandmarkMarshaller() {
    }

    public static LandmarkMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Landmark landmark, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)landmark, (String)"landmark");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)landmark.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)landmark.x(), X_BINDING);
            protocolMarshaller.marshall((Object)landmark.y(), Y_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

