/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.PersonDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PersonDetailMarshaller {
    private static final MarshallingInfo<Long> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Index").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BOUNDINGBOX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundingBox").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final PersonDetailMarshaller INSTANCE = new PersonDetailMarshaller();

    private PersonDetailMarshaller() {
    }

    public static PersonDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PersonDetail personDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)personDetail, (String)"personDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)personDetail.index(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)personDetail.boundingBox(), BOUNDINGBOX_BINDING);
            protocolMarshaller.marshall((Object)personDetail.face(), FACE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

