/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.PersonDetection;
import software.amazon.awssdk.services.rekognition.transform.PersonDetailUnmarshaller;

public class PersonDetectionUnmarshaller
implements Unmarshaller<PersonDetection, JsonUnmarshallerContext> {
    private static final PersonDetectionUnmarshaller INSTANCE = new PersonDetectionUnmarshaller();

    public PersonDetection unmarshall(JsonUnmarshallerContext context) throws Exception {
        PersonDetection.Builder personDetectionBuilder = PersonDetection.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    context.nextToken();
                    personDetectionBuilder.timestamp((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Person", targetDepth)) {
                    context.nextToken();
                    personDetectionBuilder.person(PersonDetailUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PersonDetection)personDetectionBuilder.build();
    }

    public static PersonDetectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

