/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.Point;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PointMarshaller {
    private static final MarshallingInfo<Float> X_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("X").isBinary(false).build();
    private static final MarshallingInfo<Float> Y_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Y").isBinary(false).build();
    private static final PointMarshaller INSTANCE = new PointMarshaller();

    private PointMarshaller() {
    }

    public static PointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Point point, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)point, (String)"point");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)point.x(), X_BINDING);
            protocolMarshaller.marshall((Object)point.y(), Y_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

