/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Point;

public class PointUnmarshaller
implements Unmarshaller<Point, JsonUnmarshallerContext> {
    private static final PointUnmarshaller INSTANCE = new PointUnmarshaller();

    public Point unmarshall(JsonUnmarshallerContext context) throws Exception {
        Point.Builder pointBuilder = Point.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("X", targetDepth)) {
                    context.nextToken();
                    pointBuilder.x((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Y", targetDepth)) {
                    context.nextToken();
                    pointBuilder.y((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Point)pointBuilder.build();
    }

    public static PointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

