/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartLabelDetectionRequestMarshaller
implements Marshaller<Request<StartLabelDetectionRequest>, StartLabelDetectionRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("RekognitionService.StartLabelDetection").serviceName("Amazon Rekognition").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public StartLabelDetectionRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartLabelDetectionRequest> marshall(StartLabelDetectionRequest startLabelDetectionRequest) {
        Validate.paramNotNull((Object)((Object)startLabelDetectionRequest), (String)"startLabelDetectionRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)startLabelDetectionRequest);
            protocolMarshaller.startMarshalling();
            StartLabelDetectionRequestModelMarshaller.getInstance().marshall(startLabelDetectionRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

