/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamProcessorInputMarshaller {
    private static final MarshallingInfo<StructuredPojo> KINESISVIDEOSTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisVideoStream").isBinary(false).build();
    private static final StreamProcessorInputMarshaller INSTANCE = new StreamProcessorInputMarshaller();

    private StreamProcessorInputMarshaller() {
    }

    public static StreamProcessorInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamProcessorInput streamProcessorInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamProcessorInput, (String)"streamProcessorInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamProcessorInput.kinesisVideoStream(), KINESISVIDEOSTREAM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

