/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.StreamProcessor;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamProcessorMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final StreamProcessorMarshaller INSTANCE = new StreamProcessorMarshaller();

    private StreamProcessorMarshaller() {
    }

    public static StreamProcessorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamProcessor streamProcessor, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamProcessor, (String)"streamProcessor");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamProcessor.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)streamProcessor.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

