/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.TextDetection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TextDetectionMarshaller {
    private static final MarshallingInfo<String> DETECTEDTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetectedText").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<Integer> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentId").isBinary(false).build();
    private static final MarshallingInfo<Float> CONFIDENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Confidence").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GEOMETRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Geometry").isBinary(false).build();
    private static final TextDetectionMarshaller INSTANCE = new TextDetectionMarshaller();

    private TextDetectionMarshaller() {
    }

    public static TextDetectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TextDetection textDetection, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)textDetection, (String)"textDetection");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)textDetection.detectedText(), DETECTEDTEXT_BINDING);
            protocolMarshaller.marshall((Object)textDetection.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)textDetection.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)textDetection.parentId(), PARENTID_BINDING);
            protocolMarshaller.marshall((Object)textDetection.confidence(), CONFIDENCE_BINDING);
            protocolMarshaller.marshall((Object)textDetection.geometry(), GEOMETRY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

