/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;

public class VideoMetadataUnmarshaller
implements Unmarshaller<VideoMetadata, JsonUnmarshallerContext> {
    private static final VideoMetadataUnmarshaller INSTANCE = new VideoMetadataUnmarshaller();

    public VideoMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        VideoMetadata.Builder videoMetadataBuilder = VideoMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Codec", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.codec((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DurationMillis", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.durationMillis((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Format", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.format((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FrameRate", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.frameRate((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("FrameHeight", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.frameHeight((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("FrameWidth", targetDepth)) {
                    context.nextToken();
                    videoMetadataBuilder.frameWidth((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VideoMetadata)videoMetadataBuilder.build();
    }

    public static VideoMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

