/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ComparedFaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides face metadata for target image faces that are analysed by <code>CompareFaces</code> and
 * <code>RecognizeCelebrities</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComparedFace implements StructuredPojo, ToCopyableBuilder<ComparedFace.Builder, ComparedFace> {
    private final BoundingBox boundingBox;

    private final Float confidence;

    private final List<Landmark> landmarks;

    private final Pose pose;

    private final ImageQuality quality;

    private ComparedFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Level of confidence that what the bounding box contains is a face.
     * </p>
     * 
     * @return Level of confidence that what the bounding box contains is a face.
     */
    public Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * An array of facial landmarks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of facial landmarks.
     */
    public List<Landmark> landmarks() {
        return landmarks;
    }

    /**
     * <p>
     * Indicates the pose of the face as determined by its pitch, roll, and yaw.
     * </p>
     * 
     * @return Indicates the pose of the face as determined by its pitch, roll, and yaw.
     */
    public Pose pose() {
        return pose;
    }

    /**
     * <p>
     * Identifies face image brightness and sharpness.
     * </p>
     * 
     * @return Identifies face image brightness and sharpness.
     */
    public ImageQuality quality() {
        return quality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((boundingBox() == null) ? 0 : boundingBox().hashCode());
        hashCode = 31 * hashCode + ((confidence() == null) ? 0 : confidence().hashCode());
        hashCode = 31 * hashCode + ((landmarks() == null) ? 0 : landmarks().hashCode());
        hashCode = 31 * hashCode + ((pose() == null) ? 0 : pose().hashCode());
        hashCode = 31 * hashCode + ((quality() == null) ? 0 : quality().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace) obj;
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        if (other.landmarks() == null ^ this.landmarks() == null) {
            return false;
        }
        if (other.landmarks() != null && !other.landmarks().equals(this.landmarks())) {
            return false;
        }
        if (other.pose() == null ^ this.pose() == null) {
            return false;
        }
        if (other.pose() != null && !other.pose().equals(this.pose())) {
            return false;
        }
        if (other.quality() == null ^ this.quality() == null) {
            return false;
        }
        if (other.quality() != null && !other.quality().equals(this.quality())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (boundingBox() != null) {
            sb.append("BoundingBox: ").append(boundingBox()).append(",");
        }
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        if (landmarks() != null) {
            sb.append("Landmarks: ").append(landmarks()).append(",");
        }
        if (pose() != null) {
            sb.append("Pose: ").append(pose()).append(",");
        }
        if (quality() != null) {
            sb.append("Quality: ").append(quality()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComparedFace> {
        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Level of confidence that what the bounding box contains is a face.
         * </p>
         * 
         * @param confidence
         *        Level of confidence that what the bounding box contains is a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * An array of facial landmarks.
         * </p>
         * 
         * @param landmarks
         *        An array of facial landmarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmarks(Collection<Landmark> landmarks);

        /**
         * <p>
         * An array of facial landmarks.
         * </p>
         * 
         * @param landmarks
         *        An array of facial landmarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmarks(Landmark... landmarks);

        /**
         * <p>
         * Indicates the pose of the face as determined by its pitch, roll, and yaw.
         * </p>
         * 
         * @param pose
         *        Indicates the pose of the face as determined by its pitch, roll, and yaw.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pose(Pose pose);

        /**
         * <p>
         * Identifies face image brightness and sharpness.
         * </p>
         * 
         * @param quality
         *        Identifies face image brightness and sharpness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quality(ImageQuality quality);
    }

    private static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private Float confidence;

        private List<Landmark> landmarks;

        private Pose pose;

        private ImageQuality quality;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedFace model) {
            setBoundingBox(model.boundingBox);
            setConfidence(model.confidence);
            setLandmarks(model.landmarks);
            setPose(model.pose);
            setQuality(model.quality);
        }

        public final BoundingBox getBoundingBox() {
            return boundingBox;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Collection<Landmark> getLandmarks() {
            return landmarks;
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark... landmarks) {
            landmarks(Arrays.asList(landmarks));
            return this;
        }

        public final void setLandmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
        }

        @SafeVarargs
        public final void setLandmarks(Landmark... landmarks) {
            landmarks(Arrays.asList(landmarks));
        }

        public final Pose getPose() {
            return pose;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final void setPose(Pose pose) {
            this.pose = pose;
        }

        public final ImageQuality getQuality() {
            return quality;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(ImageQuality quality) {
            this.quality = quality;
        }

        @Override
        public ComparedFace build() {
            return new ComparedFace(this);
        }
    }
}
