/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID
 * that you assigned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Face implements StructuredPojo, ToCopyableBuilder<Face.Builder, Face> {
    private final String faceId;

    private final BoundingBox boundingBox;

    private final String imageId;

    private final String externalImageId;

    private final Float confidence;

    private Face(BuilderImpl builder) {
        this.faceId = builder.faceId;
        this.boundingBox = builder.boundingBox;
        this.imageId = builder.imageId;
        this.externalImageId = builder.externalImageId;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the face.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the face.
     */
    public String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Unique identifier that Amazon Rekognition assigns to the input image.
     * </p>
     * 
     * @return Unique identifier that Amazon Rekognition assigns to the input image.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Identifier that you assign to all the faces in the input image.
     * </p>
     * 
     * @return Identifier that you assign to all the faces in the input image.
     */
    public String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * Confidence level that the bounding box contains a face (and not a different object such as a tree).
     * </p>
     * 
     * @return Confidence level that the bounding box contains a face (and not a different object such as a tree).
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((faceId() == null) ? 0 : faceId().hashCode());
        hashCode = 31 * hashCode + ((boundingBox() == null) ? 0 : boundingBox().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((externalImageId() == null) ? 0 : externalImageId().hashCode());
        hashCode = 31 * hashCode + ((confidence() == null) ? 0 : confidence().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face) obj;
        if (other.faceId() == null ^ this.faceId() == null) {
            return false;
        }
        if (other.faceId() != null && !other.faceId().equals(this.faceId())) {
            return false;
        }
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.externalImageId() == null ^ this.externalImageId() == null) {
            return false;
        }
        if (other.externalImageId() != null && !other.externalImageId().equals(this.externalImageId())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (faceId() != null) {
            sb.append("FaceId: ").append(faceId()).append(",");
        }
        if (boundingBox() != null) {
            sb.append("BoundingBox: ").append(boundingBox()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (externalImageId() != null) {
            sb.append("ExternalImageId: ").append(externalImageId()).append(",");
        }
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Face> {
        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the face.
         * </p>
         * 
         * @param faceId
         *        Unique identifier that Amazon Rekognition assigns to the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Unique identifier that Amazon Rekognition assigns to the input image.
         * </p>
         * 
         * @param imageId
         *        Unique identifier that Amazon Rekognition assigns to the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Identifier that you assign to all the faces in the input image.
         * </p>
         * 
         * @param externalImageId
         *        Identifier that you assign to all the faces in the input image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * </p>
         * 
         * @param confidence
         *        Confidence level that the bounding box contains a face (and not a different object such as a tree).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    private static final class BuilderImpl implements Builder {
        private String faceId;

        private BoundingBox boundingBox;

        private String imageId;

        private String externalImageId;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Face model) {
            setFaceId(model.faceId);
            setBoundingBox(model.boundingBox);
            setImageId(model.imageId);
            setExternalImageId(model.externalImageId);
            setConfidence(model.confidence);
        }

        public final String getFaceId() {
            return faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final BoundingBox getBoundingBox() {
            return boundingBox;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Face build() {
            return new Face(this);
        }
    }
}
