/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RecognizeCelebritiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RecognizeCelebritiesResponse.Builder, RecognizeCelebritiesResponse> {
    private final List<Celebrity> celebrityFaces;

    private final List<ComparedFace> unrecognizedFaces;

    private final String orientationCorrection;

    private RecognizeCelebritiesResponse(BuilderImpl builder) {
        this.celebrityFaces = builder.celebrityFaces;
        this.unrecognizedFaces = builder.unrecognizedFaces;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15 celebrities in an
     * image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15
     *         celebrities in an image.
     */
    public List<Celebrity> celebrityFaces() {
        return celebrityFaces;
    }

    /**
     * <p>
     * Details about each unrecognized face in the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Details about each unrecognized face in the image.
     */
    public List<ComparedFace> unrecognizedFaces() {
        return unrecognizedFaces;
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code>
     * and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value
     * of <code>OrientationCorrection</code> is null and the <code>CelebrityFaces</code> and
     * <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used to
     * correct the image orientation. Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct the orientation. The bounding box coordinates returned in
     *         <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
     *         orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If so, and the Exif metadata for the input image populates the orientation
     *         field, the value of <code>OrientationCorrection</code> is null and the <code>CelebrityFaces</code> and
     *         <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is
     *         used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String orientationCorrection() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((celebrityFaces() == null) ? 0 : celebrityFaces().hashCode());
        hashCode = 31 * hashCode + ((unrecognizedFaces() == null) ? 0 : unrecognizedFaces().hashCode());
        hashCode = 31 * hashCode + ((orientationCorrection() == null) ? 0 : orientationCorrection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResponse)) {
            return false;
        }
        RecognizeCelebritiesResponse other = (RecognizeCelebritiesResponse) obj;
        if (other.celebrityFaces() == null ^ this.celebrityFaces() == null) {
            return false;
        }
        if (other.celebrityFaces() != null && !other.celebrityFaces().equals(this.celebrityFaces())) {
            return false;
        }
        if (other.unrecognizedFaces() == null ^ this.unrecognizedFaces() == null) {
            return false;
        }
        if (other.unrecognizedFaces() != null && !other.unrecognizedFaces().equals(this.unrecognizedFaces())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        if (other.orientationCorrection() != null && !other.orientationCorrection().equals(this.orientationCorrection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (celebrityFaces() != null) {
            sb.append("CelebrityFaces: ").append(celebrityFaces()).append(",");
        }
        if (unrecognizedFaces() != null) {
            sb.append("UnrecognizedFaces: ").append(unrecognizedFaces()).append(",");
        }
        if (orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RecognizeCelebritiesResponse> {
        /**
         * <p>
         * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15 celebrities in
         * an image.
         * </p>
         * 
         * @param celebrityFaces
         *        Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15
         *        celebrities in an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrityFaces(Collection<Celebrity> celebrityFaces);

        /**
         * <p>
         * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15 celebrities in
         * an image.
         * </p>
         * 
         * @param celebrityFaces
         *        Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15
         *        celebrities in an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrityFaces(Celebrity... celebrityFaces);

        /**
         * <p>
         * Details about each unrecognized face in the image.
         * </p>
         * 
         * @param unrecognizedFaces
         *        Details about each unrecognized face in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces);

        /**
         * <p>
         * Details about each unrecognized face in the image.
         * </p>
         * 
         * @param unrecognizedFaces
         *        Details about each unrecognized face in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedFaces(ComparedFace... unrecognizedFaces);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. The bounding box coordinates returned in
         * <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null and the <code>CelebrityFaces</code> and
         * <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. The bounding box coordinates returned in
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the
         *        image orientation is corrected. </p> <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null and the
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face
         *        locations after Exif metadata is used to correct the image orientation. Images in .png format don't
         *        contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. The bounding box coordinates returned in
         * <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null and the <code>CelebrityFaces</code> and
         * <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. The bounding box coordinates returned in
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the
         *        image orientation is corrected. </p> <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null and the
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face
         *        locations after Exif metadata is used to correct the image orientation. Images in .png format don't
         *        contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    private static final class BuilderImpl implements Builder {
        private List<Celebrity> celebrityFaces;

        private List<ComparedFace> unrecognizedFaces;

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesResponse model) {
            setCelebrityFaces(model.celebrityFaces);
            setUnrecognizedFaces(model.unrecognizedFaces);
            setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<Celebrity> getCelebrityFaces() {
            return celebrityFaces;
        }

        @Override
        public final Builder celebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Celebrity... celebrityFaces) {
            celebrityFaces(Arrays.asList(celebrityFaces));
            return this;
        }

        public final void setCelebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
        }

        @SafeVarargs
        public final void setCelebrityFaces(Celebrity... celebrityFaces) {
            celebrityFaces(Arrays.asList(celebrityFaces));
        }

        public final Collection<ComparedFace> getUnrecognizedFaces() {
            return unrecognizedFaces;
        }

        @Override
        public final Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(ComparedFace... unrecognizedFaces) {
            unrecognizedFaces(Arrays.asList(unrecognizedFaces));
            return this;
        }

        public final void setUnrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
        }

        @SafeVarargs
        public final void setUnrecognizedFaces(ComparedFace... unrecognizedFaces) {
            unrecognizedFaces(Arrays.asList(unrecognizedFaces));
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final void setOrientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
        }

        @Override
        public RecognizeCelebritiesResponse build() {
            return new RecognizeCelebritiesResponse(this);
        }
    }
}
