/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageResponseUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesResponseUnmarshaller;

@SdkInternalApi
final class DefaultRekognitionClient
implements RekognitionClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultRekognitionClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public CompareFacesResponse compareFaces(CompareFacesRequest compareFacesRequest) throws InvalidParameterException, InvalidS3ObjectException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CompareFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CompareFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)compareFacesRequest).withMarshaller((Marshaller)new CompareFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateCollectionResponse createCollection(CreateCollectionRequest createCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceAlreadyExistsException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateCollectionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateCollectionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createCollectionRequest).withMarshaller((Marshaller)new CreateCollectionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteCollectionResponse deleteCollection(DeleteCollectionRequest deleteCollectionRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteCollectionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteCollectionResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteCollectionRequest).withMarshaller((Marshaller)new DeleteCollectionRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteFacesResponse deleteFaces(DeleteFacesRequest deleteFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteFacesRequest).withMarshaller((Marshaller)new DeleteFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DetectFacesResponse detectFaces(DetectFacesRequest detectFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectFacesRequest).withMarshaller((Marshaller)new DetectFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DetectLabelsResponse detectLabels(DetectLabelsRequest detectLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectLabelsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectLabelsRequest).withMarshaller((Marshaller)new DetectLabelsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DetectModerationLabelsResponse detectModerationLabels(DetectModerationLabelsRequest detectModerationLabelsRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DetectModerationLabelsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DetectModerationLabelsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)detectModerationLabelsRequest).withMarshaller((Marshaller)new DetectModerationLabelsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetCelebrityInfoResponse getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetCelebrityInfoResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCelebrityInfoResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getCelebrityInfoRequest).withMarshaller((Marshaller)new GetCelebrityInfoRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public IndexFacesResponse indexFaces(IndexFacesRequest indexFacesRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new IndexFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (IndexFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)indexFacesRequest).withMarshaller((Marshaller)new IndexFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListCollectionsResponse listCollections() throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        return this.listCollections((ListCollectionsRequest)((Object)ListCollectionsRequest.builder().build()));
    }

    @Override
    public ListCollectionsResponse listCollections(ListCollectionsRequest listCollectionsRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListCollectionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListCollectionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listCollectionsRequest).withMarshaller((Marshaller)new ListCollectionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListFacesResponse listFaces(ListFacesRequest listFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, InvalidPaginationTokenException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listFacesRequest).withMarshaller((Marshaller)new ListFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RecognizeCelebritiesResponse recognizeCelebrities(RecognizeCelebritiesRequest recognizeCelebritiesRequest) throws InvalidS3ObjectException, InvalidParameterException, InvalidImageFormatException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RecognizeCelebritiesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RecognizeCelebritiesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)recognizeCelebritiesRequest).withMarshaller((Marshaller)new RecognizeCelebritiesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SearchFacesResponse searchFaces(SearchFacesRequest searchFacesRequest) throws InvalidParameterException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchFacesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SearchFacesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchFacesRequest).withMarshaller((Marshaller)new SearchFacesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public SearchFacesByImageResponse searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) throws InvalidS3ObjectException, InvalidParameterException, ImageTooLargeException, AccessDeniedException, InternalServerErrorException, ThrottlingException, ProvisionedThroughputExceededException, ResourceNotFoundException, InvalidImageFormatException, SdkBaseException, SdkClientException, RekognitionException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new SearchFacesByImageResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SearchFacesByImageResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)searchFacesByImageRequest).withMarshaller((Marshaller)new SearchFacesByImageRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(RekognitionException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidImageFormatException").withModeledClass(InvalidImageFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageTooLargeException").withModeledClass(ImageTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationTokenException").withModeledClass(InvalidPaginationTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidS3ObjectException").withModeledClass(InvalidS3ObjectException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

