/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.FaceRecord;
import software.amazon.awssdk.services.rekognition.model.FaceRecordListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IndexFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, IndexFacesResponse> {
    private final List<FaceRecord> faceRecords;
    private final String orientationCorrection;

    private IndexFacesResponse(BuilderImpl builder) {
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<FaceRecord> faceRecords() {
        return this.faceRecords;
    }

    public String orientationCorrection() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.faceRecords() == null ? 0 : this.faceRecords().hashCode());
        hashCode = 31 * hashCode + (this.orientationCorrection() == null ? 0 : this.orientationCorrection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse)((Object)obj);
        if (other.faceRecords() == null ^ this.faceRecords() == null) {
            return false;
        }
        if (other.faceRecords() != null && !other.faceRecords().equals(this.faceRecords())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        return other.orientationCorrection() == null || other.orientationCorrection().equals(this.orientationCorrection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.faceRecords() != null) {
            sb.append("FaceRecords: ").append(this.faceRecords()).append(",");
        }
        if (this.orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<FaceRecord> faceRecords;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            this.setFaceRecords(model.faceRecords);
            this.setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceRecord> getFaceRecords() {
            return this.faceRecords;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord ... faceRecords) {
            this.faceRecords(Arrays.asList(faceRecords));
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
        }

        @SafeVarargs
        public final void setFaceRecords(FaceRecord ... faceRecords) {
            this.faceRecords(Arrays.asList(faceRecords));
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final void setOrientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
        }

        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IndexFacesResponse> {
        public Builder faceRecords(Collection<FaceRecord> var1);

        public Builder faceRecords(FaceRecord ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

