/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompareFacesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CompareFacesRequest.Builder, CompareFacesRequest> {
    private final Image sourceImage;

    private final Image targetImage;

    private final Float similarityThreshold;

    private CompareFacesRequest(BuilderImpl builder) {
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
    }

    /**
     * <p>
     * The source image, either as bytes or as an S3 object.
     * </p>
     * 
     * @return The source image, either as bytes or as an S3 object.
     */
    public Image sourceImage() {
        return sourceImage;
    }

    /**
     * <p>
     * The target image, either as bytes or as an S3 object.
     * </p>
     * 
     * @return The target image, either as bytes or as an S3 object.
     */
    public Image targetImage() {
        return targetImage;
    }

    /**
     * <p>
     * The minimum level of confidence in the face matches that a match must meet to be included in the
     * <code>FaceMatches</code> array.
     * </p>
     * 
     * @return The minimum level of confidence in the face matches that a match must meet to be included in the
     *         <code>FaceMatches</code> array.
     */
    public Float similarityThreshold() {
        return similarityThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sourceImage() == null) ? 0 : sourceImage().hashCode());
        hashCode = 31 * hashCode + ((targetImage() == null) ? 0 : targetImage().hashCode());
        hashCode = 31 * hashCode + ((similarityThreshold() == null) ? 0 : similarityThreshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest) obj;
        if (other.sourceImage() == null ^ this.sourceImage() == null) {
            return false;
        }
        if (other.sourceImage() != null && !other.sourceImage().equals(this.sourceImage())) {
            return false;
        }
        if (other.targetImage() == null ^ this.targetImage() == null) {
            return false;
        }
        if (other.targetImage() != null && !other.targetImage().equals(this.targetImage())) {
            return false;
        }
        if (other.similarityThreshold() == null ^ this.similarityThreshold() == null) {
            return false;
        }
        if (other.similarityThreshold() != null && !other.similarityThreshold().equals(this.similarityThreshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sourceImage() != null) {
            sb.append("SourceImage: ").append(sourceImage()).append(",");
        }
        if (targetImage() != null) {
            sb.append("TargetImage: ").append(targetImage()).append(",");
        }
        if (similarityThreshold() != null) {
            sb.append("SimilarityThreshold: ").append(similarityThreshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CompareFacesRequest> {
        /**
         * <p>
         * The source image, either as bytes or as an S3 object.
         * </p>
         * 
         * @param sourceImage
         *        The source image, either as bytes or as an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImage(Image sourceImage);

        /**
         * <p>
         * The target image, either as bytes or as an S3 object.
         * </p>
         * 
         * @param targetImage
         *        The target image, either as bytes or as an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetImage(Image targetImage);

        /**
         * <p>
         * The minimum level of confidence in the face matches that a match must meet to be included in the
         * <code>FaceMatches</code> array.
         * </p>
         * 
         * @param similarityThreshold
         *        The minimum level of confidence in the face matches that a match must meet to be included in the
         *        <code>FaceMatches</code> array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarityThreshold(Float similarityThreshold);
    }

    private static final class BuilderImpl implements Builder {
        private Image sourceImage;

        private Image targetImage;

        private Float similarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            setSourceImage(model.sourceImage);
            setTargetImage(model.targetImage);
            setSimilarityThreshold(model.similarityThreshold);
        }

        public final Image getSourceImage() {
            return sourceImage;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final void setSourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
        }

        public final Image getTargetImage() {
            return targetImage;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final void setTargetImage(Image targetImage) {
            this.targetImage = targetImage;
        }

        public final Float getSimilarityThreshold() {
            return similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        @Override
        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }
    }
}
