/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteFacesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteFacesRequest.Builder, DeleteFacesRequest> {
    private final String collectionId;

    private final List<String> faceIds;

    private DeleteFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceIds = builder.faceIds;
    }

    /**
     * <p>
     * Collection from which to remove the specific faces.
     * </p>
     * 
     * @return Collection from which to remove the specific faces.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * An array of face IDs to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of face IDs to delete.
     */
    public List<String> faceIds() {
        return faceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((collectionId() == null) ? 0 : collectionId().hashCode());
        hashCode = 31 * hashCode + ((faceIds() == null) ? 0 : faceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesRequest)) {
            return false;
        }
        DeleteFacesRequest other = (DeleteFacesRequest) obj;
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.faceIds() == null ^ this.faceIds() == null) {
            return false;
        }
        if (other.faceIds() != null && !other.faceIds().equals(this.faceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (collectionId() != null) {
            sb.append("CollectionId: ").append(collectionId()).append(",");
        }
        if (faceIds() != null) {
            sb.append("FaceIds: ").append(faceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteFacesRequest> {
        /**
         * <p>
         * Collection from which to remove the specific faces.
         * </p>
         * 
         * @param collectionId
         *        Collection from which to remove the specific faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * An array of face IDs to delete.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(Collection<String> faceIds);

        /**
         * <p>
         * An array of face IDs to delete.
         * </p>
         * 
         * @param faceIds
         *        An array of face IDs to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(String... faceIds);
    }

    private static final class BuilderImpl implements Builder {
        private String collectionId;

        private List<String> faceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesRequest model) {
            setCollectionId(model.collectionId);
            setFaceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Collection<String> getFaceIds() {
            return faceIds;
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String... faceIds) {
            faceIds(Arrays.asList(faceIds));
            return this;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
        }

        @Override
        public DeleteFacesRequest build() {
            return new DeleteFacesRequest(this);
        }
    }
}
