/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ImageQualityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies face image brightness and sharpness.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImageQuality implements StructuredPojo, ToCopyableBuilder<ImageQuality.Builder, ImageQuality> {
    private final Float brightness;

    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    /**
     * <p>
     * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a brighter face image.
     * </p>
     * 
     * @return Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a brighter face image.
     */
    public Float brightness() {
        return brightness;
    }

    /**
     * <p>
     * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a sharper face image.
     * </p>
     * 
     * @return Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a sharper face image.
     */
    public Float sharpness() {
        return sharpness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((brightness() == null) ? 0 : brightness().hashCode());
        hashCode = 31 * hashCode + ((sharpness() == null) ? 0 : sharpness().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality) obj;
        if (other.brightness() == null ^ this.brightness() == null) {
            return false;
        }
        if (other.brightness() != null && !other.brightness().equals(this.brightness())) {
            return false;
        }
        if (other.sharpness() == null ^ this.sharpness() == null) {
            return false;
        }
        if (other.sharpness() != null && !other.sharpness().equals(this.sharpness())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (brightness() != null) {
            sb.append("Brightness: ").append(brightness()).append(",");
        }
        if (sharpness() != null) {
            sb.append("Sharpness: ").append(sharpness()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageQualityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ImageQuality> {
        /**
         * <p>
         * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
         * higher value indicates a brighter face image.
         * </p>
         * 
         * @param brightness
         *        Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive).
         *        A higher value indicates a brighter face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brightness(Float brightness);

        /**
         * <p>
         * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
         * value indicates a sharper face image.
         * </p>
         * 
         * @param sharpness
         *        Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
         *        higher value indicates a sharper face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Float sharpness);
    }

    private static final class BuilderImpl implements Builder {
        private Float brightness;

        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            setBrightness(model.brightness);
            setSharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return brightness;
        }

        @Override
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        public final Float getSharpness() {
            return sharpness;
        }

        @Override
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public ImageQuality build() {
            return new ImageQuality(this);
        }
    }
}
