/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchFacesByImageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<SearchFacesByImageResponse.Builder, SearchFacesByImageResponse> {
    private final BoundingBox searchedFaceBoundingBox;

    private final Float searchedFaceConfidence;

    private final List<FaceMatch> faceMatches;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
    }

    /**
     * <p>
     * The bounding box around the face in the input image that Amazon Rekognition used for the search.
     * </p>
     * 
     * @return The bounding box around the face in the input image that Amazon Rekognition used for the search.
     */
    public BoundingBox searchedFaceBoundingBox() {
        return searchedFaceBoundingBox;
    }

    /**
     * <p>
     * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     * </p>
     * 
     * @return The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
     */
    public Float searchedFaceConfidence() {
        return searchedFaceConfidence;
    }

    /**
     * <p>
     * An array of faces that match the input face, along with the confidence in the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of faces that match the input face, along with the confidence in the match.
     */
    public List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((searchedFaceBoundingBox() == null) ? 0 : searchedFaceBoundingBox().hashCode());
        hashCode = 31 * hashCode + ((searchedFaceConfidence() == null) ? 0 : searchedFaceConfidence().hashCode());
        hashCode = 31 * hashCode + ((faceMatches() == null) ? 0 : faceMatches().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse) obj;
        if (other.searchedFaceBoundingBox() == null ^ this.searchedFaceBoundingBox() == null) {
            return false;
        }
        if (other.searchedFaceBoundingBox() != null && !other.searchedFaceBoundingBox().equals(this.searchedFaceBoundingBox())) {
            return false;
        }
        if (other.searchedFaceConfidence() == null ^ this.searchedFaceConfidence() == null) {
            return false;
        }
        if (other.searchedFaceConfidence() != null && !other.searchedFaceConfidence().equals(this.searchedFaceConfidence())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        if (other.faceMatches() != null && !other.faceMatches().equals(this.faceMatches())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (searchedFaceBoundingBox() != null) {
            sb.append("SearchedFaceBoundingBox: ").append(searchedFaceBoundingBox()).append(",");
        }
        if (searchedFaceConfidence() != null) {
            sb.append("SearchedFaceConfidence: ").append(searchedFaceConfidence()).append(",");
        }
        if (faceMatches() != null) {
            sb.append("FaceMatches: ").append(faceMatches()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SearchFacesByImageResponse> {
        /**
         * <p>
         * The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * </p>
         * 
         * @param searchedFaceBoundingBox
         *        The bounding box around the face in the input image that Amazon Rekognition used for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox);

        /**
         * <p>
         * The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * </p>
         * 
         * @param searchedFaceConfidence
         *        The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceConfidence(Float searchedFaceConfidence);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that match the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that match the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);
    }

    private static final class BuilderImpl implements Builder {
        private BoundingBox searchedFaceBoundingBox;

        private Float searchedFaceConfidence;

        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            setSearchedFaceBoundingBox(model.searchedFaceBoundingBox);
            setSearchedFaceConfidence(model.searchedFaceConfidence);
            setFaceMatches(model.faceMatches);
        }

        public final BoundingBox getSearchedFaceBoundingBox() {
            return searchedFaceBoundingBox;
        }

        @Override
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
        }

        public final Float getSearchedFaceConfidence() {
            return searchedFaceConfidence;
        }

        @Override
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        public final Collection<FaceMatch> getFaceMatches() {
            return faceMatches;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
        }

        @Override
        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }
    }
}
