/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * FaceDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class FaceDetailUnmarshaller implements Unmarshaller<FaceDetail, JsonUnmarshallerContext> {

    public FaceDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        FaceDetail.Builder faceDetailBuilder = FaceDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BoundingBox", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.boundingBox(BoundingBoxUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AgeRange", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.ageRange(AgeRangeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Smile", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.smile(SmileUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Eyeglasses", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.eyeglasses(EyeglassesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Sunglasses", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.sunglasses(SunglassesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Gender", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.gender(GenderUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Beard", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.beard(BeardUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Mustache", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.mustache(MustacheUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EyesOpen", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.eyesOpen(EyeOpenUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MouthOpen", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.mouthOpen(MouthOpenUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Emotions", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.emotions(new ListUnmarshaller<Emotion>(EmotionUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("Landmarks", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.landmarks(new ListUnmarshaller<Landmark>(LandmarkUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("Pose", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.pose(PoseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Quality", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.quality(ImageQualityUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    faceDetailBuilder.confidence(context.getUnmarshaller(Float.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return faceDetailBuilder.build();
    }

    private static final FaceDetailUnmarshaller INSTANCE = new FaceDetailUnmarshaller();

    public static FaceDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
