/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.Celebrity;
import software.amazon.awssdk.services.rekognition.model.CelebrityListCopier;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.ComparedFaceListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecognizeCelebritiesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RecognizeCelebritiesResponse> {
    private final List<Celebrity> celebrityFaces;
    private final List<ComparedFace> unrecognizedFaces;
    private final String orientationCorrection;

    private RecognizeCelebritiesResponse(BuilderImpl builder) {
        this.celebrityFaces = builder.celebrityFaces;
        this.unrecognizedFaces = builder.unrecognizedFaces;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<Celebrity> celebrityFaces() {
        return this.celebrityFaces;
    }

    public List<ComparedFace> unrecognizedFaces() {
        return this.unrecognizedFaces;
    }

    public String orientationCorrection() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.celebrityFaces() == null ? 0 : this.celebrityFaces().hashCode());
        hashCode = 31 * hashCode + (this.unrecognizedFaces() == null ? 0 : this.unrecognizedFaces().hashCode());
        hashCode = 31 * hashCode + (this.orientationCorrection() == null ? 0 : this.orientationCorrection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResponse)) {
            return false;
        }
        RecognizeCelebritiesResponse other = (RecognizeCelebritiesResponse)((Object)obj);
        if (other.celebrityFaces() == null ^ this.celebrityFaces() == null) {
            return false;
        }
        if (other.celebrityFaces() != null && !other.celebrityFaces().equals(this.celebrityFaces())) {
            return false;
        }
        if (other.unrecognizedFaces() == null ^ this.unrecognizedFaces() == null) {
            return false;
        }
        if (other.unrecognizedFaces() != null && !other.unrecognizedFaces().equals(this.unrecognizedFaces())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        return other.orientationCorrection() == null || other.orientationCorrection().equals(this.orientationCorrection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.celebrityFaces() != null) {
            sb.append("CelebrityFaces: ").append(this.celebrityFaces()).append(",");
        }
        if (this.unrecognizedFaces() != null) {
            sb.append("UnrecognizedFaces: ").append(this.unrecognizedFaces()).append(",");
        }
        if (this.orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Celebrity> celebrityFaces;
        private List<ComparedFace> unrecognizedFaces;
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesResponse model) {
            this.setCelebrityFaces(model.celebrityFaces);
            this.setUnrecognizedFaces(model.unrecognizedFaces);
            this.setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<Celebrity> getCelebrityFaces() {
            return this.celebrityFaces;
        }

        @Override
        public final Builder celebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Celebrity ... celebrityFaces) {
            this.celebrityFaces(Arrays.asList(celebrityFaces));
            return this;
        }

        public final void setCelebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
        }

        public final Collection<ComparedFace> getUnrecognizedFaces() {
            return this.unrecognizedFaces;
        }

        @Override
        public final Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(ComparedFace ... unrecognizedFaces) {
            this.unrecognizedFaces(Arrays.asList(unrecognizedFaces));
            return this;
        }

        public final void setUnrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public RecognizeCelebritiesResponse build() {
            return new RecognizeCelebritiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecognizeCelebritiesResponse> {
        public Builder celebrityFaces(Collection<Celebrity> var1);

        public Builder celebrityFaces(Celebrity ... var1);

        public Builder unrecognizedFaces(Collection<ComparedFace> var1);

        public Builder unrecognizedFaces(ComparedFace ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

