/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectModerationLabelsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DetectModerationLabelsResponse.Builder, DetectModerationLabelsResponse> {
    private final List<ModerationLabel> moderationLabels;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        this.moderationLabels = builder.moderationLabels;
    }

    /**
     * <p>
     * An array of labels for explicit or suggestive adult content found in the image. The list includes the top-level
     * label and each child label detected in the image. This is useful for filtering specific categories of content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of labels for explicit or suggestive adult content found in the image. The list includes the
     *         top-level label and each child label detected in the image. This is useful for filtering specific
     *         categories of content.
     */
    public List<ModerationLabel> moderationLabels() {
        return moderationLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((moderationLabels() == null) ? 0 : moderationLabels().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse) obj;
        if (other.moderationLabels() == null ^ this.moderationLabels() == null) {
            return false;
        }
        if (other.moderationLabels() != null && !other.moderationLabels().equals(this.moderationLabels())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (moderationLabels() != null) {
            sb.append("ModerationLabels: ").append(moderationLabels()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        /**
         * <p>
         * An array of labels for explicit or suggestive adult content found in the image. The list includes the
         * top-level label and each child label detected in the image. This is useful for filtering specific categories
         * of content.
         * </p>
         * 
         * @param moderationLabels
         *        An array of labels for explicit or suggestive adult content found in the image. The list includes the
         *        top-level label and each child label detected in the image. This is useful for filtering specific
         *        categories of content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(Collection<ModerationLabel> moderationLabels);

        /**
         * <p>
         * An array of labels for explicit or suggestive adult content found in the image. The list includes the
         * top-level label and each child label detected in the image. This is useful for filtering specific categories
         * of content.
         * </p>
         * 
         * @param moderationLabels
         *        An array of labels for explicit or suggestive adult content found in the image. The list includes the
         *        top-level label and each child label detected in the image. This is useful for filtering specific
         *        categories of content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(ModerationLabel... moderationLabels);
    }

    private static final class BuilderImpl implements Builder {
        private List<ModerationLabel> moderationLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            setModerationLabels(model.moderationLabels);
        }

        public final Collection<ModerationLabel> getModerationLabels() {
            return moderationLabels;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel... moderationLabels) {
            moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }
    }
}
