/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.rekognition.model.S3Object;
import software.amazon.awssdk.services.rekognition.transform.ImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Image
implements StructuredPojo,
ToCopyableBuilder<Builder, Image> {
    private final ByteBuffer bytes;
    private final S3Object s3Object;

    private Image(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.s3Object = builder.s3Object;
    }

    public ByteBuffer bytes() {
        return this.bytes == null ? null : this.bytes.asReadOnlyBuffer();
    }

    public S3Object s3Object() {
        return this.s3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bytes() == null ? 0 : this.bytes().hashCode());
        hashCode = 31 * hashCode + (this.s3Object() == null ? 0 : this.s3Object().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.bytes() == null ^ this.bytes() == null) {
            return false;
        }
        if (other.bytes() != null && !other.bytes().equals(this.bytes())) {
            return false;
        }
        if (other.s3Object() == null ^ this.s3Object() == null) {
            return false;
        }
        return other.s3Object() == null || other.s3Object().equals(this.s3Object());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bytes() != null) {
            sb.append("Bytes: ").append(this.bytes()).append(",");
        }
        if (this.s3Object() != null) {
            sb.append("S3Object: ").append(this.s3Object()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer bytes;
        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.setBytes(model.bytes);
            this.setS3Object(model.s3Object);
        }

        public final ByteBuffer getBytes() {
            return this.bytes;
        }

        @Override
        public final Builder bytes(ByteBuffer bytes) {
            this.bytes = StandardMemberCopier.copy((ByteBuffer)bytes);
            return this;
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes = StandardMemberCopier.copy((ByteBuffer)bytes);
        }

        public final S3Object getS3Object() {
            return this.s3Object;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final void setS3Object(S3Object s3Object) {
            this.s3Object = s3Object;
        }

        public Image build() {
            return new Image(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Image> {
        public Builder bytes(ByteBuffer var1);

        public Builder s3Object(S3Object var1);
    }
}

