/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Celebrity;
import software.amazon.awssdk.services.rekognition.transform.ComparedFaceUnmarshaller;

public class CelebrityUnmarshaller
implements Unmarshaller<Celebrity, JsonUnmarshallerContext> {
    private static final CelebrityUnmarshaller INSTANCE = new CelebrityUnmarshaller();

    public Celebrity unmarshall(JsonUnmarshallerContext context) throws Exception {
        Celebrity.Builder celebrityBuilder = Celebrity.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Urls", targetDepth)) {
                    context.nextToken();
                    celebrityBuilder.urls(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    celebrityBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    celebrityBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Face", targetDepth)) {
                    context.nextToken();
                    celebrityBuilder.face(ComparedFaceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MatchConfidence", targetDepth)) {
                    context.nextToken();
                    celebrityBuilder.matchConfidence((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Celebrity)celebrityBuilder.build();
    }

    public static CelebrityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

