/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the Amazon Rekognition API reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RekognitionAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link RekognitionAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static RekognitionAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RekognitionAsyncClient}.
     */
    static RekognitionAsyncClientBuilder builder() {
        return new DefaultRekognitionAsyncClientBuilder();
    }

    /**
     * <p>
     * Compares a face in the <i>source</i> input image with each face detected in the <i>target</i> input image.
     * </p>
     * <note>
     * <p>
     * If the source image contains multiple faces, the service detects the largest face and compares it with each face
     * detected in the target image.
     * </p>
     * </note>
     * <p>
     * In response, the operation returns an array of face matches ordered by similarity score in descending order. For
     * each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, role,
     * and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the
     * bounding box contains a face). The response also provides a similarity score, which indicates how closely the
     * faces match.
     * </p>
     * <note>
     * <p>
     * By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You
     * can change this value by specifying the <code>SimilarityThreshold</code> parameter.
     * </p>
     * </note>
     * <p>
     * <code>CompareFaces</code> also returns an array of faces that don't match the source image. For each face, it
     * returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns
     * information about the face in the source image, including the bounding box of the face and confidence value.
     * </p>
     * <p>
     * If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the
     * source and target images. Use these values to display the images with the correct image orientation.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, data returned by this operation doesn't persist.
     * </p>
     * </note>
     * <p>
     * For an example, see <a>get-started-exercise-compare-faces</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.
     * </p>
     *
     * @param compareFacesRequest
     * @return A Java Future containing the result of the CompareFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CompareFaces
     */
    default CompletableFuture<CompareFacesResponse> compareFaces(CompareFacesRequest compareFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a collection in an AWS Region. You can add faces to the collection using the operation.
     * </p>
     * <p>
     * For example, you might create collections, one for each of your application users. A user can then index faces
     * using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search
     * the collection for faces in the user-specific container.
     * </p>
     * <note>
     * <p>
     * Collection names are case-sensitive.
     * </p>
     * </note>
     * <p>
     * For an example, see <a>example1</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action.
     * </p>
     *
     * @param createCollectionRequest
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceAlreadyExistsException A collection with the specified ID already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateCollection
     */
    default CompletableFuture<CreateCollectionResponse> createCollection(CreateCollectionRequest createCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified collection. Note that this operation removes all faces in the collection. For an example,
     * see <a>example1</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.
     * </p>
     *
     * @param deleteCollectionRequest
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteCollection
     */
    default CompletableFuture<DeleteCollectionResponse> deleteCollection(DeleteCollectionRequest deleteCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the
     * collection.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.
     * </p>
     *
     * @param deleteFacesRequest
     * @return A Java Future containing the result of the DeleteFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteFaces
     */
    default CompletableFuture<DeleteFacesResponse> deleteFaces(DeleteFacesRequest deleteFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects faces within an image (JPEG or PNG) that is provided as input.
     * </p>
     * <p>
     * For each face detected, the operation returns face details including a bounding box of the face, a confidence
     * value (that the bounding box contains a face), and a fixed set of attributes such as facial landmarks (for
     * example, coordinates of eye and mouth), gender, presence of beard, sunglasses, etc.
     * </p>
     * <p>
     * The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm
     * may not detect the faces or might detect faces with lower confidence.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * </note>
     * <p>
     * For an example, see <a>get-started-exercise-detect-faces</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action.
     * </p>
     *
     * @param detectFacesRequest
     * @return A Java Future containing the result of the DetectFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectFaces
     */
    default CompletableFuture<DetectFacesResponse> detectFaces(DetectFacesRequest detectFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects instances of real-world labels within an image (JPEG or PNG) provided as input. This includes objects
     * like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape,
     * evening, and nature. For an example, see <a>get-started-exercise-detect-labels</a>.
     * </p>
     * <p>
     * For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and
     * the level of confidence that the image contains the object. For example, suppose the input image has a
     * lighthouse, the sea, and a rock. The response will include all three labels, one for each object.
     * </p>
     * <p>
     * <code>{Name: lighthouse, Confidence: 98.4629}</code>
     * </p>
     * <p>
     * <code>{Name: rock,Confidence: 79.2097}</code>
     * </p>
     * <p>
     * <code> {Name: sea,Confidence: 75.061}</code>
     * </p>
     * <p>
     * In the preceding example, the operation returns one label for each of the three objects. The operation can also
     * return multiple labels for the same object in the image. For example, if the input image shows a flower (for
     * example, a tulip), the operation might return the following three labels.
     * </p>
     * <p>
     * <code>{Name: flower,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: plant,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: tulip,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * In this example, the detection algorithm more precisely identifies the flower as a tulip.
     * </p>
     * <p>
     * You can provide the input image as an S3 object or as base64-encoded bytes. In response, the API returns an array
     * of labels. In addition, the response also includes the orientation correction. Optionally, you can specify
     * <code>MinConfidence</code> to control the confidence threshold for the labels returned. The default is 50%. You
     * can also add the <code>MaxLabels</code> parameter to limit the number of labels returned.
     * </p>
     * <note>
     * <p>
     * If the object detected is a person, the operation doesn't provide the same facial details that the
     * <a>DetectFaces</a> operation provides.
     * </p>
     * </note>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action.
     * </p>
     *
     * @param detectLabelsRequest
     * @return A Java Future containing the result of the DetectLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectLabels
     */
    default CompletableFuture<DetectLabelsResponse> detectLabels(DetectLabelsRequest detectLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects explicit or suggestive adult content in a specified JPEG or PNG format image. Use
     * <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might
     * want to filter images that contain nudity, but not images containing suggestive content.
     * </p>
     * <p>
     * To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of
     * content are appropriate. For information about moderation labels, see <a>image-moderation</a>.
     * </p>
     *
     * @param detectModerationLabelsRequest
     * @return A Java Future containing the result of the DetectModerationLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectModerationLabels
     */
    default CompletableFuture<DetectModerationLabelsResponse> detectModerationLabels(
            DetectModerationLabelsRequest detectModerationLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the name and additional information about a celebrity based on his or her Rekognition ID. The additional
     * information is returned as an array of URLs. If there is no additional information about the celebrity, this list
     * is empty. For more information, see <a>celebrity-recognition</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action.
     * </p>
     *
     * @param getCelebrityInfoRequest
     * @return A Java Future containing the result of the GetCelebrityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityInfo
     */
    default CompletableFuture<GetCelebrityInfoResponse> getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects faces in the input image and adds them to the specified collection.
     * </p>
     * <p>
     * Amazon Rekognition does not save the actual faces detected. Instead, the underlying detection algorithm first
     * detects the faces in the input image, and for each face extracts facial features into a feature vector, and
     * stores it in the back-end database. Amazon Rekognition uses feature vectors when performing face match and search
     * operations using the and operations.
     * </p>
     * <p>
     * If you provide the optional <code>externalImageID</code> for the input image you provided, Amazon Rekognition
     * associates this ID with all faces that it detects. When you call the operation, the response returns the external
     * ID. You can use this external image ID to create a client-side index to associate the faces with each image. You
     * can then use the index to find all faces in an image.
     * </p>
     * <p>
     * In response, the operation returns an array of metadata for all detected faces. This includes, the bounding box
     * of the detected face, confidence value (indicating the bounding box contains a face), a face ID assigned by the
     * service for each face that is detected and stored, and an image ID assigned by the service for the input image.
     * If you request all facial attributes (using the <code>detectionAttributes</code> parameter, Amazon Rekognition
     * returns detailed facial attributes such as facial landmarks (for example, location of eye and mount) and other
     * facial attributes such gender. If you provide the same image, specify the same collection, and use the same
     * external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face metadata.
     * </p>
     * <p>
     * For an example, see <a>example2</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.
     * </p>
     *
     * @param indexFacesRequest
     * @return A Java Future containing the result of the IndexFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.IndexFaces
     */
    default CompletableFuture<IndexFacesResponse> indexFaces(IndexFacesRequest indexFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see <a>example1</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     *
     * @param listCollectionsRequest
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default CompletableFuture<ListCollectionsResponse> listCollections(ListCollectionsRequest listCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see
     * <a>example3</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     *
     * @param listFacesRequest
     * @return A Java Future containing the result of the ListFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    default CompletableFuture<ListFacesResponse> listFaces(ListFacesRequest listFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of celebrities recognized in the input image. The image is passed either as base64-encoded image
     * bytes or as a reference to an image in an Amazon S3 bucket. The image must be either a PNG or JPEG formatted
     * file. For more information, see <a>celebrity-recognition</a>.
     * </p>
     * <p>
     * <code>RecognizeCelebrities</code> returns the 15 largest faces in the image. It lists recognized celebrities in
     * the <code>CelebrityFaces</code> list and unrecognized faces in the <code>UnrecognizedFaces</code> list. The
     * operation doesn't return celebrities whose face sizes are smaller than the largest 15 faces in the image.
     * </p>
     * <p>
     * For each celebrity recognized, the API returns a <code>Celebrity</code> object. The <code>Celebrity</code> object
     * contains the celebrity name, ID, URL links to additional information, match confidence, and a
     * <code>ComparedFace</code> object that you can use to locate the celebrity's face on the image.
     * </p>
     * <p>
     * Rekognition does not retain information about which images a celebrity has been recognized in. Your application
     * must store this information and use the <code>Celebrity</code> ID property as a unique identifier for the
     * celebrity. If you don't store the celebrity name or additional information URLs returned by
     * <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the operation.
     * </p>
     * <p>
     * For an example, see <a>recognize-celebrities-tutorial</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.
     * </p>
     *
     * @param recognizeCelebritiesRequest
     * @return A Java Future containing the result of the RecognizeCelebrities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.RecognizeCelebrities
     */
    default CompletableFuture<RecognizeCelebritiesResponse> recognizeCelebrities(
            RecognizeCelebritiesRequest recognizeCelebritiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID
     * when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features
     * of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * The operation response returns an array of faces that match, ordered by similarity score with the highest
     * similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the
     * metadata, the response also includes a <code>confidence</code> value for each face match, indicating the
     * confidence that the specific face matches the input face.
     * </p>
     * <p>
     * For an example, see <a>example3</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.
     * </p>
     *
     * @param searchFacesRequest
     * @return A Java Future containing the result of the SearchFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFaces
     */
    default CompletableFuture<SearchFacesResponse> searchFaces(SearchFacesRequest searchFacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given input image, first detects the largest face in the image, and then searches the specified collection
     * for matching faces. The operation compares the features of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * To search for all faces in an input image, you might first call the operation, and then use the face IDs returned
     * in subsequent calls to the operation.
     * </p>
     * <p>
     * You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face
     * crops, which then you can pass in to the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * The response returns an array of faces that match, ordered by similarity score with the highest similarity first.
     * More specifically, it is an array of metadata for each face match found. Along with the metadata, the response
     * also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response,
     * the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the
     * face that Amazon Rekognition used for the input image.
     * </p>
     * <p>
     * For an example, see <a>example3</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.
     * </p>
     *
     * @param searchFacesByImageRequest
     * @return A Java Future containing the result of the SearchFacesByImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. For more information, see
     *         <a>limits</a>.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFacesByImage
     */
    default CompletableFuture<SearchFacesByImageResponse> searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see <a>example1</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     *
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException Collection specified in the request is not found.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    default CompletableFuture<ListCollectionsResponse> listCollections() {
        return listCollections(ListCollectionsRequest.builder().build());
    }
}
