/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.AgeRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing the estimated age range, in years, for a face.
 * </p>
 * <p>
 * Rekognition estimates an age-range for faces detected in the input image. Estimated age ranges can overlap; a face of
 * a 5 year old may have an estimated range of 4-6 whilst the face of a 6 year old may have an estimated range of 4-8.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AgeRange implements StructuredPojo, ToCopyableBuilder<AgeRange.Builder, AgeRange> {
    private final Integer low;

    private final Integer high;

    private AgeRange(BuilderImpl builder) {
        this.low = builder.low;
        this.high = builder.high;
    }

    /**
     * <p>
     * The lowest estimated age.
     * </p>
     * 
     * @return The lowest estimated age.
     */
    public Integer low() {
        return low;
    }

    /**
     * <p>
     * The highest estimated age.
     * </p>
     * 
     * @return The highest estimated age.
     */
    public Integer high() {
        return high;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((low() == null) ? 0 : low().hashCode());
        hashCode = 31 * hashCode + ((high() == null) ? 0 : high().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgeRange)) {
            return false;
        }
        AgeRange other = (AgeRange) obj;
        if (other.low() == null ^ this.low() == null) {
            return false;
        }
        if (other.low() != null && !other.low().equals(this.low())) {
            return false;
        }
        if (other.high() == null ^ this.high() == null) {
            return false;
        }
        if (other.high() != null && !other.high().equals(this.high())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (low() != null) {
            sb.append("Low: ").append(low()).append(",");
        }
        if (high() != null) {
            sb.append("High: ").append(high()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Low":
            return Optional.of(clazz.cast(low()));
        case "High":
            return Optional.of(clazz.cast(high()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AgeRange> {
        /**
         * <p>
         * The lowest estimated age.
         * </p>
         * 
         * @param low
         *        The lowest estimated age.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Integer low);

        /**
         * <p>
         * The highest estimated age.
         * </p>
         * 
         * @param high
         *        The highest estimated age.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Integer high);
    }

    static final class BuilderImpl implements Builder {
        private Integer low;

        private Integer high;

        private BuilderImpl() {
        }

        private BuilderImpl(AgeRange model) {
            low(model.low);
            high(model.high);
        }

        public final Integer getLow() {
            return low;
        }

        @Override
        public final Builder low(Integer low) {
            this.low = low;
            return this;
        }

        public final void setLow(Integer low) {
            this.low = low;
        }

        public final Integer getHigh() {
            return high;
        }

        @Override
        public final Builder high(Integer high) {
            this.high = high;
            return this;
        }

        public final void setHigh(Integer high) {
            this.high = high;
        }

        @Override
        public AgeRange build() {
            return new AgeRange(this);
        }
    }
}
