/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.CelebrityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a celebrity recognized by the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Celebrity implements StructuredPojo, ToCopyableBuilder<Celebrity.Builder, Celebrity> {
    private final List<String> urls;

    private final String name;

    private final String id;

    private final ComparedFace face;

    private final Float matchConfidence;

    private Celebrity(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.face = builder.face;
        this.matchConfidence = builder.matchConfidence;
    }

    /**
     * <p>
     * An array of URLs pointing to additional information about the celebrity. If there is no additional information
     * about the celebrity, this list is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of URLs pointing to additional information about the celebrity. If there is no additional
     *         information about the celebrity, this list is empty.
     */
    public List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The name of the celebrity.
     * </p>
     * 
     * @return The name of the celebrity.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the celebrity.
     * </p>
     * 
     * @return A unique identifier for the celebrity.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Provides information about the celebrity's face, such as its location on the image.
     * </p>
     * 
     * @return Provides information about the celebrity's face, such as its location on the image.
     */
    public ComparedFace face() {
        return face;
    }

    /**
     * <p>
     * The confidence, in percentage, that Rekognition has that the recognized face is the celebrity.
     * </p>
     * 
     * @return The confidence, in percentage, that Rekognition has that the recognized face is the celebrity.
     */
    public Float matchConfidence() {
        return matchConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((urls() == null) ? 0 : urls().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((face() == null) ? 0 : face().hashCode());
        hashCode = 31 * hashCode + ((matchConfidence() == null) ? 0 : matchConfidence().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Celebrity)) {
            return false;
        }
        Celebrity other = (Celebrity) obj;
        if (other.urls() == null ^ this.urls() == null) {
            return false;
        }
        if (other.urls() != null && !other.urls().equals(this.urls())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        if (other.face() != null && !other.face().equals(this.face())) {
            return false;
        }
        if (other.matchConfidence() == null ^ this.matchConfidence() == null) {
            return false;
        }
        if (other.matchConfidence() != null && !other.matchConfidence().equals(this.matchConfidence())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (urls() != null) {
            sb.append("Urls: ").append(urls()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (face() != null) {
            sb.append("Face: ").append(face()).append(",");
        }
        if (matchConfidence() != null) {
            sb.append("MatchConfidence: ").append(matchConfidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Urls":
            return Optional.of(clazz.cast(urls()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Face":
            return Optional.of(clazz.cast(face()));
        case "MatchConfidence":
            return Optional.of(clazz.cast(matchConfidence()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CelebrityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Celebrity> {
        /**
         * <p>
         * An array of URLs pointing to additional information about the celebrity. If there is no additional
         * information about the celebrity, this list is empty.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional information about the celebrity. If there is no additional
         *        information about the celebrity, this list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * An array of URLs pointing to additional information about the celebrity. If there is no additional
         * information about the celebrity, this list is empty.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional information about the celebrity. If there is no additional
         *        information about the celebrity, this list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The name of the celebrity.
         * </p>
         * 
         * @param name
         *        The name of the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the celebrity.
         * </p>
         * 
         * @param id
         *        A unique identifier for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Provides information about the celebrity's face, such as its location on the image.
         * </p>
         * 
         * @param face
         *        Provides information about the celebrity's face, such as its location on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(ComparedFace face);

        /**
         * <p>
         * The confidence, in percentage, that Rekognition has that the recognized face is the celebrity.
         * </p>
         * 
         * @param matchConfidence
         *        The confidence, in percentage, that Rekognition has that the recognized face is the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchConfidence(Float matchConfidence);
    }

    static final class BuilderImpl implements Builder {
        private List<String> urls;

        private String name;

        private String id;

        private ComparedFace face;

        private Float matchConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Celebrity model) {
            urls(model.urls);
            name(model.name);
            id(model.id);
            face(model.face);
            matchConfidence(model.matchConfidence);
        }

        public final Collection<String> getUrls() {
            return urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ComparedFace.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final Float getMatchConfidence() {
            return matchConfidence;
        }

        @Override
        public final Builder matchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
            return this;
        }

        public final void setMatchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
        }

        @Override
        public Celebrity build() {
            return new Celebrity(this);
        }
    }
}
