/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCollectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateCollectionRequest.Builder, CreateCollectionRequest> {
    private final String collectionId;

    private CreateCollectionRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
    }

    /**
     * <p>
     * ID for the collection that you are creating.
     * </p>
     * 
     * @return ID for the collection that you are creating.
     */
    public String collectionId() {
        return collectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((collectionId() == null) ? 0 : collectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionRequest)) {
            return false;
        }
        CreateCollectionRequest other = (CreateCollectionRequest) obj;
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (collectionId() != null) {
            sb.append("CollectionId: ").append(collectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCollectionRequest> {
        /**
         * <p>
         * ID for the collection that you are creating.
         * </p>
         * 
         * @param collectionId
         *        ID for the collection that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);
    }

    static final class BuilderImpl implements Builder {
        private String collectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionRequest model) {
            collectionId(model.collectionId);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public CreateCollectionRequest build() {
            return new CreateCollectionRequest(this);
        }
    }
}
