/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCollectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateCollectionResponse.Builder, CreateCollectionResponse> {
    private final Integer statusCode;

    private final String collectionArn;

    private CreateCollectionResponse(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.collectionArn = builder.collectionArn;
    }

    /**
     * <p>
     * HTTP status code indicating the result of the operation.
     * </p>
     * 
     * @return HTTP status code indicating the result of the operation.
     */
    public Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
     */
    public String collectionArn() {
        return collectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((statusCode() == null) ? 0 : statusCode().hashCode());
        hashCode = 31 * hashCode + ((collectionArn() == null) ? 0 : collectionArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionResponse)) {
            return false;
        }
        CreateCollectionResponse other = (CreateCollectionResponse) obj;
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.collectionArn() == null ^ this.collectionArn() == null) {
            return false;
        }
        if (other.collectionArn() != null && !other.collectionArn().equals(this.collectionArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (statusCode() != null) {
            sb.append("StatusCode: ").append(statusCode()).append(",");
        }
        if (collectionArn() != null) {
            sb.append("CollectionArn: ").append(collectionArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.of(clazz.cast(statusCode()));
        case "CollectionArn":
            return Optional.of(clazz.cast(collectionArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCollectionResponse> {
        /**
         * <p>
         * HTTP status code indicating the result of the operation.
         * </p>
         * 
         * @param statusCode
         *        HTTP status code indicating the result of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources.
         * </p>
         * 
         * @param collectionArn
         *        Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionArn(String collectionArn);
    }

    static final class BuilderImpl implements Builder {
        private Integer statusCode;

        private String collectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionResponse model) {
            statusCode(model.statusCode);
            collectionArn(model.collectionArn);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getCollectionArn() {
            return collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public CreateCollectionResponse build() {
            return new CreateCollectionResponse(this);
        }
    }
}
