/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteCollectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteCollectionResponse.Builder, DeleteCollectionResponse> {
    private final Integer statusCode;

    private DeleteCollectionResponse(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * HTTP status code that indicates the result of the operation.
     * </p>
     * 
     * @return HTTP status code that indicates the result of the operation.
     */
    public Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((statusCode() == null) ? 0 : statusCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCollectionResponse)) {
            return false;
        }
        DeleteCollectionResponse other = (DeleteCollectionResponse) obj;
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (statusCode() != null) {
            sb.append("StatusCode: ").append(statusCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.of(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteCollectionResponse> {
        /**
         * <p>
         * HTTP status code that indicates the result of the operation.
         * </p>
         * 
         * @param statusCode
         *        HTTP status code that indicates the result of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl implements Builder {
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCollectionResponse model) {
            statusCode(model.statusCode);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public DeleteCollectionResponse build() {
            return new DeleteCollectionResponse(this);
        }
    }
}
