/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectLabelsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DetectLabelsResponse.Builder, DetectLabelsResponse> {
    private final List<Label> labels;

    private final String orientationCorrection;

    private DetectLabelsResponse(BuilderImpl builder) {
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * An array of labels for the real-world objects detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of labels for the real-world objects detected.
     */
    public List<Label> labels() {
        return labels;
    }

    /**
     * <p>
     * The orientation of the input image (counter-clockwise direction). If your application displays the image, you can
     * use this value to correct the orientation. If Amazon Rekognition detects that the input image was rotated (for
     * example, by 90 degrees), it first corrects the orientation before detecting the labels.
     * </p>
     * <note>
     * <p>
     * If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform orientation
     * correction and the value of OrientationCorrection will be null.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionString}.
     * </p>
     * 
     * @return The orientation of the input image (counter-clockwise direction). If your application displays the image,
     *         you can use this value to correct the orientation. If Amazon Rekognition detects that the input image was
     *         rotated (for example, by 90 degrees), it first corrects the orientation before detecting the labels. </p>
     *         <note>
     *         <p>
     *         If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
     *         orientation correction and the value of OrientationCorrection will be null.
     *         </p>
     * @see OrientationCorrection
     */
    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The orientation of the input image (counter-clockwise direction). If your application displays the image, you can
     * use this value to correct the orientation. If Amazon Rekognition detects that the input image was rotated (for
     * example, by 90 degrees), it first corrects the orientation before detecting the labels.
     * </p>
     * <note>
     * <p>
     * If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform orientation
     * correction and the value of OrientationCorrection will be null.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionString}.
     * </p>
     * 
     * @return The orientation of the input image (counter-clockwise direction). If your application displays the image,
     *         you can use this value to correct the orientation. If Amazon Rekognition detects that the input image was
     *         rotated (for example, by 90 degrees), it first corrects the orientation before detecting the labels. </p>
     *         <note>
     *         <p>
     *         If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
     *         orientation correction and the value of OrientationCorrection will be null.
     *         </p>
     * @see OrientationCorrection
     */
    public String orientationCorrectionString() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((labels() == null) ? 0 : labels().hashCode());
        hashCode = 31 * hashCode + ((orientationCorrectionString() == null) ? 0 : orientationCorrectionString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse) obj;
        if (other.labels() == null ^ this.labels() == null) {
            return false;
        }
        if (other.labels() != null && !other.labels().equals(this.labels())) {
            return false;
        }
        if (other.orientationCorrectionString() == null ^ this.orientationCorrectionString() == null) {
            return false;
        }
        if (other.orientationCorrectionString() != null
                && !other.orientationCorrectionString().equals(this.orientationCorrectionString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (labels() != null) {
            sb.append("Labels: ").append(labels()).append(",");
        }
        if (orientationCorrectionString() != null) {
            sb.append("OrientationCorrection: ").append(orientationCorrectionString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Labels":
            return Optional.of(clazz.cast(labels()));
        case "OrientationCorrection":
            return Optional.of(clazz.cast(orientationCorrectionString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetectLabelsResponse> {
        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * The orientation of the input image (counter-clockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. If Amazon Rekognition detects that the input image was rotated
         * (for example, by 90 degrees), it first corrects the orientation before detecting the labels.
         * </p>
         * <note>
         * <p>
         * If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
         * orientation correction and the value of OrientationCorrection will be null.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counter-clockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. If Amazon Rekognition detects that the input
         *        image was rotated (for example, by 90 degrees), it first corrects the orientation before detecting the
         *        labels. </p> <note>
         *        <p>
         *        If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
         *        orientation correction and the value of OrientationCorrection will be null.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counter-clockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. If Amazon Rekognition detects that the input image was rotated
         * (for example, by 90 degrees), it first corrects the orientation before detecting the labels.
         * </p>
         * <note>
         * <p>
         * If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
         * orientation correction and the value of OrientationCorrection will be null.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counter-clockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. If Amazon Rekognition detects that the input
         *        image was rotated (for example, by 90 degrees), it first corrects the orientation before detecting the
         *        labels. </p> <note>
         *        <p>
         *        If the input image Exif metadata populates the orientation field, Amazon Rekognition does not perform
         *        orientation correction and the value of OrientationCorrection will be null.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    static final class BuilderImpl implements Builder {
        private List<Label> labels;

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            labels(model.labels);
            orientationCorrection(model.orientationCorrection);
        }

        public final Collection<Label.Builder> getLabels() {
            return labels != null ? labels.stream().map(Label::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }
    }
}
