/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceMatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides face metadata. In addition, it also provides the confidence in the match of this face with the input face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FaceMatch implements StructuredPojo, ToCopyableBuilder<FaceMatch.Builder, FaceMatch> {
    private final Float similarity;

    private final Face face;

    private FaceMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.face = builder.face;
    }

    /**
     * <p>
     * Confidence in the match of this face with the input face.
     * </p>
     * 
     * @return Confidence in the match of this face with the input face.
     */
    public Float similarity() {
        return similarity;
    }

    /**
     * <p>
     * Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image
     * ID that you assigned.
     * </p>
     * 
     * @return Describes the face properties such as the bounding box, face ID, image ID of the source image, and
     *         external image ID that you assigned.
     */
    public Face face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((similarity() == null) ? 0 : similarity().hashCode());
        hashCode = 31 * hashCode + ((face() == null) ? 0 : face().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceMatch)) {
            return false;
        }
        FaceMatch other = (FaceMatch) obj;
        if (other.similarity() == null ^ this.similarity() == null) {
            return false;
        }
        if (other.similarity() != null && !other.similarity().equals(this.similarity())) {
            return false;
        }
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        if (other.face() != null && !other.face().equals(this.face())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (similarity() != null) {
            sb.append("Similarity: ").append(similarity()).append(",");
        }
        if (face() != null) {
            sb.append("Face: ").append(face()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Similarity":
            return Optional.of(clazz.cast(similarity()));
        case "Face":
            return Optional.of(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FaceMatch> {
        /**
         * <p>
         * Confidence in the match of this face with the input face.
         * </p>
         * 
         * @param similarity
         *        Confidence in the match of this face with the input face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarity(Float similarity);

        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the source image, and external
         * image ID that you assigned.
         * </p>
         * 
         * @param face
         *        Describes the face properties such as the bounding box, face ID, image ID of the source image, and
         *        external image ID that you assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(Face face);
    }

    static final class BuilderImpl implements Builder {
        private Float similarity;

        private Face face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceMatch model) {
            similarity(model.similarity);
            face(model.face);
        }

        public final Float getSimilarity() {
            return similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        public final Face.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public FaceMatch build() {
            return new FaceMatch(this);
        }
    }
}
