/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.FaceRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing both the face metadata (stored in the back-end database) and facial attributes that are detected
 * but aren't stored in the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FaceRecord implements StructuredPojo, ToCopyableBuilder<FaceRecord.Builder, FaceRecord> {
    private final Face face;

    private final FaceDetail faceDetail;

    private FaceRecord(BuilderImpl builder) {
        this.face = builder.face;
        this.faceDetail = builder.faceDetail;
    }

    /**
     * <p>
     * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image
     * ID that you assigned.
     * </p>
     * 
     * @return Describes the face properties such as the bounding box, face ID, image ID of the input image, and
     *         external image ID that you assigned.
     */
    public Face face() {
        return face;
    }

    /**
     * <p>
     * Structure containing attributes of the face that the algorithm detected.
     * </p>
     * 
     * @return Structure containing attributes of the face that the algorithm detected.
     */
    public FaceDetail faceDetail() {
        return faceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((face() == null) ? 0 : face().hashCode());
        hashCode = 31 * hashCode + ((faceDetail() == null) ? 0 : faceDetail().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceRecord)) {
            return false;
        }
        FaceRecord other = (FaceRecord) obj;
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        if (other.face() != null && !other.face().equals(this.face())) {
            return false;
        }
        if (other.faceDetail() == null ^ this.faceDetail() == null) {
            return false;
        }
        if (other.faceDetail() != null && !other.faceDetail().equals(this.faceDetail())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (face() != null) {
            sb.append("Face: ").append(face()).append(",");
        }
        if (faceDetail() != null) {
            sb.append("FaceDetail: ").append(faceDetail()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Face":
            return Optional.of(clazz.cast(face()));
        case "FaceDetail":
            return Optional.of(clazz.cast(faceDetail()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FaceRecord> {
        /**
         * <p>
         * Describes the face properties such as the bounding box, face ID, image ID of the input image, and external
         * image ID that you assigned.
         * </p>
         * 
         * @param face
         *        Describes the face properties such as the bounding box, face ID, image ID of the input image, and
         *        external image ID that you assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(Face face);

        /**
         * <p>
         * Structure containing attributes of the face that the algorithm detected.
         * </p>
         * 
         * @param faceDetail
         *        Structure containing attributes of the face that the algorithm detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetail(FaceDetail faceDetail);
    }

    static final class BuilderImpl implements Builder {
        private Face face;

        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceRecord model) {
            face(model.face);
            faceDetail(model.faceDetail);
        }

        public final Face.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final FaceDetail.Builder getFaceDetail() {
            return faceDetail != null ? faceDetail.toBuilder() : null;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail.BuilderImpl faceDetail) {
            this.faceDetail = faceDetail != null ? faceDetail.build() : null;
        }

        @Override
        public FaceRecord build() {
            return new FaceRecord(this);
        }
    }
}
