/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCollectionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCollectionsResponse.Builder, ListCollectionsResponse> {
    private final List<String> collectionIds;

    private final String nextToken;

    private ListCollectionsResponse(BuilderImpl builder) {
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of collection IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of collection IDs.
     */
    public List<String> collectionIds() {
        return collectionIds;
    }

    /**
     * <p>
     * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
     * request to fetch the next set of collection IDs.
     * </p>
     * 
     * @return If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
     *         subsequent request to fetch the next set of collection IDs.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((collectionIds() == null) ? 0 : collectionIds().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse) obj;
        if (other.collectionIds() == null ^ this.collectionIds() == null) {
            return false;
        }
        if (other.collectionIds() != null && !other.collectionIds().equals(this.collectionIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (collectionIds() != null) {
            sb.append("CollectionIds: ").append(collectionIds()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionIds":
            return Optional.of(clazz.cast(collectionIds()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCollectionsResponse> {
        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(Collection<String> collectionIds);

        /**
         * <p>
         * An array of collection IDs.
         * </p>
         * 
         * @param collectionIds
         *        An array of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionIds(String... collectionIds);

        /**
         * <p>
         * If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent
         * request to fetch the next set of collection IDs.
         * </p>
         * 
         * @param nextToken
         *        If the result is truncated, the response provides a <code>NextToken</code> that you can use in the
         *        subsequent request to fetch the next set of collection IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<String> collectionIds;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            collectionIds(model.collectionIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getCollectionIds() {
            return collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String... collectionIds) {
            collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }
    }
}
