/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RecognizeCelebritiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RecognizeCelebritiesRequest.Builder, RecognizeCelebritiesRequest> {
    private final Image image;

    private RecognizeCelebritiesRequest(BuilderImpl builder) {
        this.image = builder.image;
    }

    /**
     * <p>
     * The input image to use for celebrity recognition.
     * </p>
     * 
     * @return The input image to use for celebrity recognition.
     */
    public Image image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesRequest)) {
            return false;
        }
        RecognizeCelebritiesRequest other = (RecognizeCelebritiesRequest) obj;
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.of(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RecognizeCelebritiesRequest> {
        /**
         * <p>
         * The input image to use for celebrity recognition.
         * </p>
         * 
         * @param image
         *        The input image to use for celebrity recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);
    }

    static final class BuilderImpl implements Builder {
        private Image image;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesRequest model) {
            image(model.image);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public RecognizeCelebritiesRequest build() {
            return new RecognizeCelebritiesRequest(this);
        }
    }
}
