/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchFacesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SearchFacesRequest.Builder, SearchFacesRequest> {
    private final String collectionId;

    private final String faceId;

    private final Integer maxFaces;

    private final Float faceMatchThreshold;

    private SearchFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceId = builder.faceId;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    /**
     * <p>
     * ID of the collection the face belongs to.
     * </p>
     * 
     * @return ID of the collection the face belongs to.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * ID of a face to find matches for in the collection.
     * </p>
     * 
     * @return ID of a face to find matches for in the collection.
     */
    public String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence
     * in the match.
     * </p>
     * 
     * @return Maximum number of faces to return. The operation returns the maximum number of faces with the highest
     *         confidence in the match.
     */
    public Integer maxFaces() {
        return maxFaces;
    }

    /**
     * <p>
     * Optional value specifying the minimum confidence in the face match to return. For example, don't return any
     * matches where confidence in matches is less than 70%.
     * </p>
     * 
     * @return Optional value specifying the minimum confidence in the face match to return. For example, don't return
     *         any matches where confidence in matches is less than 70%.
     */
    public Float faceMatchThreshold() {
        return faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((collectionId() == null) ? 0 : collectionId().hashCode());
        hashCode = 31 * hashCode + ((faceId() == null) ? 0 : faceId().hashCode());
        hashCode = 31 * hashCode + ((maxFaces() == null) ? 0 : maxFaces().hashCode());
        hashCode = 31 * hashCode + ((faceMatchThreshold() == null) ? 0 : faceMatchThreshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesRequest)) {
            return false;
        }
        SearchFacesRequest other = (SearchFacesRequest) obj;
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.faceId() == null ^ this.faceId() == null) {
            return false;
        }
        if (other.faceId() != null && !other.faceId().equals(this.faceId())) {
            return false;
        }
        if (other.maxFaces() == null ^ this.maxFaces() == null) {
            return false;
        }
        if (other.maxFaces() != null && !other.maxFaces().equals(this.maxFaces())) {
            return false;
        }
        if (other.faceMatchThreshold() == null ^ this.faceMatchThreshold() == null) {
            return false;
        }
        if (other.faceMatchThreshold() != null && !other.faceMatchThreshold().equals(this.faceMatchThreshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (collectionId() != null) {
            sb.append("CollectionId: ").append(collectionId()).append(",");
        }
        if (faceId() != null) {
            sb.append("FaceId: ").append(faceId()).append(",");
        }
        if (maxFaces() != null) {
            sb.append("MaxFaces: ").append(maxFaces()).append(",");
        }
        if (faceMatchThreshold() != null) {
            sb.append("FaceMatchThreshold: ").append(faceMatchThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        case "FaceId":
            return Optional.of(clazz.cast(faceId()));
        case "MaxFaces":
            return Optional.of(clazz.cast(maxFaces()));
        case "FaceMatchThreshold":
            return Optional.of(clazz.cast(faceMatchThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SearchFacesRequest> {
        /**
         * <p>
         * ID of the collection the face belongs to.
         * </p>
         * 
         * @param collectionId
         *        ID of the collection the face belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * ID of a face to find matches for in the collection.
         * </p>
         * 
         * @param faceId
         *        ID of a face to find matches for in the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         * confidence in the match.
         * </p>
         * 
         * @param maxFaces
         *        Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         *        confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFaces(Integer maxFaces);

        /**
         * <p>
         * Optional value specifying the minimum confidence in the face match to return. For example, don't return any
         * matches where confidence in matches is less than 70%.
         * </p>
         * 
         * @param faceMatchThreshold
         *        Optional value specifying the minimum confidence in the face match to return. For example, don't
         *        return any matches where confidence in matches is less than 70%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatchThreshold(Float faceMatchThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String collectionId;

        private String faceId;

        private Integer maxFaces;

        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesRequest model) {
            collectionId(model.collectionId);
            faceId(model.faceId);
            maxFaces(model.maxFaces);
            faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final String getFaceId() {
            return faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final Integer getMaxFaces() {
            return maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public SearchFacesRequest build() {
            return new SearchFacesRequest(this);
        }
    }
}
