/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.ComparedFace;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.services.rekognition.transform.CelebrityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Celebrity
implements StructuredPojo,
ToCopyableBuilder<Builder, Celebrity> {
    private final List<String> urls;
    private final String name;
    private final String id;
    private final ComparedFace face;
    private final Float matchConfidence;

    private Celebrity(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.face = builder.face;
        this.matchConfidence = builder.matchConfidence;
    }

    public List<String> urls() {
        return this.urls;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ComparedFace face() {
        return this.face;
    }

    public Float matchConfidence() {
        return this.matchConfidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.urls() == null ? 0 : this.urls().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.face() == null ? 0 : this.face().hashCode());
        hashCode = 31 * hashCode + (this.matchConfidence() == null ? 0 : this.matchConfidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Celebrity)) {
            return false;
        }
        Celebrity other = (Celebrity)obj;
        if (other.urls() == null ^ this.urls() == null) {
            return false;
        }
        if (other.urls() != null && !other.urls().equals(this.urls())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        if (other.face() != null && !other.face().equals(this.face())) {
            return false;
        }
        if (other.matchConfidence() == null ^ this.matchConfidence() == null) {
            return false;
        }
        return other.matchConfidence() == null || other.matchConfidence().equals(this.matchConfidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.urls() != null) {
            sb.append("Urls: ").append(this.urls()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.face() != null) {
            sb.append("Face: ").append(this.face()).append(",");
        }
        if (this.matchConfidence() != null) {
            sb.append("MatchConfidence: ").append(this.matchConfidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Urls": {
                return Optional.of(clazz.cast(this.urls()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Face": {
                return Optional.of(clazz.cast(this.face()));
            }
            case "MatchConfidence": {
                return Optional.of(clazz.cast(this.matchConfidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CelebrityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> urls;
        private String name;
        private String id;
        private ComparedFace face;
        private Float matchConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Celebrity model) {
            this.urls(model.urls);
            this.name(model.name);
            this.id(model.id);
            this.face(model.face);
            this.matchConfidence(model.matchConfidence);
        }

        public final Collection<String> getUrls() {
            return this.urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            this.urls(Arrays.asList(urls));
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ComparedFace.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public final Float getMatchConfidence() {
            return this.matchConfidence;
        }

        @Override
        public final Builder matchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
            return this;
        }

        public final void setMatchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
        }

        public Celebrity build() {
            return new Celebrity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Celebrity> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);

        public Builder id(String var1);

        public Builder face(ComparedFace var1);

        public Builder matchConfidence(Float var1);
    }
}

