/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompareFacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompareFacesRequest> {
    private final Image sourceImage;
    private final Image targetImage;
    private final Float similarityThreshold;

    private CompareFacesRequest(BuilderImpl builder) {
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
    }

    public Image sourceImage() {
        return this.sourceImage;
    }

    public Image targetImage() {
        return this.targetImage;
    }

    public Float similarityThreshold() {
        return this.similarityThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceImage() == null ? 0 : this.sourceImage().hashCode());
        hashCode = 31 * hashCode + (this.targetImage() == null ? 0 : this.targetImage().hashCode());
        hashCode = 31 * hashCode + (this.similarityThreshold() == null ? 0 : this.similarityThreshold().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest)((Object)obj);
        if (other.sourceImage() == null ^ this.sourceImage() == null) {
            return false;
        }
        if (other.sourceImage() != null && !other.sourceImage().equals(this.sourceImage())) {
            return false;
        }
        if (other.targetImage() == null ^ this.targetImage() == null) {
            return false;
        }
        if (other.targetImage() != null && !other.targetImage().equals(this.targetImage())) {
            return false;
        }
        if (other.similarityThreshold() == null ^ this.similarityThreshold() == null) {
            return false;
        }
        return other.similarityThreshold() == null || other.similarityThreshold().equals(this.similarityThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceImage() != null) {
            sb.append("SourceImage: ").append(this.sourceImage()).append(",");
        }
        if (this.targetImage() != null) {
            sb.append("TargetImage: ").append(this.targetImage()).append(",");
        }
        if (this.similarityThreshold() != null) {
            sb.append("SimilarityThreshold: ").append(this.similarityThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImage": {
                return Optional.of(clazz.cast(this.sourceImage()));
            }
            case "TargetImage": {
                return Optional.of(clazz.cast(this.targetImage()));
            }
            case "SimilarityThreshold": {
                return Optional.of(clazz.cast(this.similarityThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Image sourceImage;
        private Image targetImage;
        private Float similarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            this.sourceImage(model.sourceImage);
            this.targetImage(model.targetImage);
            this.similarityThreshold(model.similarityThreshold);
        }

        public final Image.Builder getSourceImage() {
            return this.sourceImage != null ? this.sourceImage.toBuilder() : null;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final void setSourceImage(Image.BuilderImpl sourceImage) {
            this.sourceImage = sourceImage != null ? sourceImage.build() : null;
        }

        public final Image.Builder getTargetImage() {
            return this.targetImage != null ? this.targetImage.toBuilder() : null;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final void setTargetImage(Image.BuilderImpl targetImage) {
            this.targetImage = targetImage != null ? targetImage.build() : null;
        }

        public final Float getSimilarityThreshold() {
            return this.similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompareFacesRequest> {
        public Builder sourceImage(Image var1);

        public Builder targetImage(Image var1);

        public Builder similarityThreshold(Float var1);
    }
}

