/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.transform.FaceMatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FaceMatch
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceMatch> {
    private final Float similarity;
    private final Face face;

    private FaceMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.face = builder.face;
    }

    public Float similarity() {
        return this.similarity;
    }

    public Face face() {
        return this.face;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.similarity() == null ? 0 : this.similarity().hashCode());
        hashCode = 31 * hashCode + (this.face() == null ? 0 : this.face().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceMatch)) {
            return false;
        }
        FaceMatch other = (FaceMatch)obj;
        if (other.similarity() == null ^ this.similarity() == null) {
            return false;
        }
        if (other.similarity() != null && !other.similarity().equals(this.similarity())) {
            return false;
        }
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        return other.face() == null || other.face().equals(this.face());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.similarity() != null) {
            sb.append("Similarity: ").append(this.similarity()).append(",");
        }
        if (this.face() != null) {
            sb.append("Face: ").append(this.face()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Similarity": {
                return Optional.of(clazz.cast(this.similarity()));
            }
            case "Face": {
                return Optional.of(clazz.cast(this.face()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceMatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float similarity;
        private Face face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceMatch model) {
            this.similarity(model.similarity);
            this.face(model.face);
        }

        public final Float getSimilarity() {
            return this.similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        public final Face.Builder getFace() {
            return this.face != null ? this.face.toBuilder() : null;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        public FaceMatch build() {
            return new FaceMatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceMatch> {
        public Builder similarity(Float var1);

        public Builder face(Face var1);
    }
}

