/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.CollectionIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCollectionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCollectionsResponse> {
    private final List<String> collectionIds;
    private final String nextToken;

    private ListCollectionsResponse(BuilderImpl builder) {
        this.collectionIds = builder.collectionIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.collectionIds() == null ? 0 : this.collectionIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResponse)) {
            return false;
        }
        ListCollectionsResponse other = (ListCollectionsResponse)((Object)obj);
        if (other.collectionIds() == null ^ this.collectionIds() == null) {
            return false;
        }
        if (other.collectionIds() != null && !other.collectionIds().equals(this.collectionIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.collectionIds() != null) {
            sb.append("CollectionIds: ").append(this.collectionIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionIds": {
                return Optional.of(clazz.cast(this.collectionIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> collectionIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsResponse model) {
            this.collectionIds(model.collectionIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getCollectionIds() {
            return this.collectionIds;
        }

        @Override
        public final Builder collectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionIds(String ... collectionIds) {
            this.collectionIds(Arrays.asList(collectionIds));
            return this;
        }

        public final void setCollectionIds(Collection<String> collectionIds) {
            this.collectionIds = CollectionIdListCopier.copy(collectionIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListCollectionsResponse build() {
            return new ListCollectionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCollectionsResponse> {
        public Builder collectionIds(Collection<String> var1);

        public Builder collectionIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

