/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListFacesResponse> {
    private final List<Face> faces;
    private final String nextToken;

    private ListFacesResponse(BuilderImpl builder) {
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
    }

    public List<Face> faces() {
        return this.faces;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.faces() == null ? 0 : this.faces().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse)((Object)obj);
        if (other.faces() == null ^ this.faces() == null) {
            return false;
        }
        if (other.faces() != null && !other.faces().equals(this.faces())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.faces() != null) {
            sb.append("Faces: ").append(this.faces()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Faces": {
                return Optional.of(clazz.cast(this.faces()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Face> faces;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            this.faces(model.faces);
            this.nextToken(model.nextToken);
        }

        public final Collection<Face.Builder> getFaces() {
            return this.faces != null ? (Collection)this.faces.stream().map(Face::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Face ... faces) {
            this.faces(Arrays.asList(faces));
            return this;
        }

        public final void setFaces(Collection<Face.BuilderImpl> faces) {
            this.faces = FaceListCopier.copyFromBuilder(faces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListFacesResponse> {
        public Builder faces(Collection<Face> var1);

        public Builder faces(Face ... var1);

        public Builder nextToken(String var1);
    }
}

