/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchFacesByImageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchFacesByImageResponse> {
    private final BoundingBox searchedFaceBoundingBox;
    private final Float searchedFaceConfidence;
    private final List<FaceMatch> faceMatches;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
    }

    public BoundingBox searchedFaceBoundingBox() {
        return this.searchedFaceBoundingBox;
    }

    public Float searchedFaceConfidence() {
        return this.searchedFaceConfidence;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.searchedFaceBoundingBox() == null ? 0 : this.searchedFaceBoundingBox().hashCode());
        hashCode = 31 * hashCode + (this.searchedFaceConfidence() == null ? 0 : this.searchedFaceConfidence().hashCode());
        hashCode = 31 * hashCode + (this.faceMatches() == null ? 0 : this.faceMatches().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse)((Object)obj);
        if (other.searchedFaceBoundingBox() == null ^ this.searchedFaceBoundingBox() == null) {
            return false;
        }
        if (other.searchedFaceBoundingBox() != null && !other.searchedFaceBoundingBox().equals(this.searchedFaceBoundingBox())) {
            return false;
        }
        if (other.searchedFaceConfidence() == null ^ this.searchedFaceConfidence() == null) {
            return false;
        }
        if (other.searchedFaceConfidence() != null && !other.searchedFaceConfidence().equals(this.searchedFaceConfidence())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        return other.faceMatches() == null || other.faceMatches().equals(this.faceMatches());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.searchedFaceBoundingBox() != null) {
            sb.append("SearchedFaceBoundingBox: ").append(this.searchedFaceBoundingBox()).append(",");
        }
        if (this.searchedFaceConfidence() != null) {
            sb.append("SearchedFaceConfidence: ").append(this.searchedFaceConfidence()).append(",");
        }
        if (this.faceMatches() != null) {
            sb.append("FaceMatches: ").append(this.faceMatches()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchedFaceBoundingBox": {
                return Optional.of(clazz.cast(this.searchedFaceBoundingBox()));
            }
            case "SearchedFaceConfidence": {
                return Optional.of(clazz.cast(this.searchedFaceConfidence()));
            }
            case "FaceMatches": {
                return Optional.of(clazz.cast(this.faceMatches()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox searchedFaceBoundingBox;
        private Float searchedFaceConfidence;
        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            this.searchedFaceBoundingBox(model.searchedFaceBoundingBox);
            this.searchedFaceConfidence(model.searchedFaceConfidence);
            this.faceMatches(model.faceMatches);
        }

        public final BoundingBox.Builder getSearchedFaceBoundingBox() {
            return this.searchedFaceBoundingBox != null ? this.searchedFaceBoundingBox.toBuilder() : null;
        }

        @Override
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox.BuilderImpl searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox != null ? searchedFaceBoundingBox.build() : null;
        }

        public final Float getSearchedFaceConfidence() {
            return this.searchedFaceConfidence;
        }

        @Override
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        public final Collection<FaceMatch.Builder> getFaceMatches() {
            return this.faceMatches != null ? (Collection)this.faceMatches.stream().map(FaceMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchFacesByImageResponse> {
        public Builder searchedFaceBoundingBox(BoundingBox var1);

        public Builder searchedFaceConfidence(Float var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);
    }
}

