/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchFacesByImageRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SearchFacesByImageRequest.Builder, SearchFacesByImageRequest> {
    private final String collectionId;

    private final Image image;

    private final Integer maxFaces;

    private final Float faceMatchThreshold;

    private SearchFacesByImageRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    /**
     * <p>
     * ID of the collection to search.
     * </p>
     * 
     * @return ID of the collection to search.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The input image as bytes or an S3 object.
     * </p>
     * 
     * @return The input image as bytes or an S3 object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence
     * in the match.
     * </p>
     * 
     * @return Maximum number of faces to return. The operation returns the maximum number of faces with the highest
     *         confidence in the match.
     */
    public Integer maxFaces() {
        return maxFaces;
    }

    /**
     * <p>
     * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches
     * where confidence in matches is less than 70%.
     * </p>
     * 
     * @return (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
     *         matches where confidence in matches is less than 70%.
     */
    public Float faceMatchThreshold() {
        return faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatchThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageRequest)) {
            return false;
        }
        SearchFacesByImageRequest other = (SearchFacesByImageRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(image(), other.image())
                && Objects.equals(maxFaces(), other.maxFaces())
                && Objects.equals(faceMatchThreshold(), other.faceMatchThreshold());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (collectionId() != null) {
            sb.append("CollectionId: ").append(collectionId()).append(",");
        }
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (maxFaces() != null) {
            sb.append("MaxFaces: ").append(maxFaces()).append(",");
        }
        if (faceMatchThreshold() != null) {
            sb.append("FaceMatchThreshold: ").append(faceMatchThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.of(clazz.cast(collectionId()));
        case "Image":
            return Optional.of(clazz.cast(image()));
        case "MaxFaces":
            return Optional.of(clazz.cast(maxFaces()));
        case "FaceMatchThreshold":
            return Optional.of(clazz.cast(faceMatchThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SearchFacesByImageRequest> {
        /**
         * <p>
         * ID of the collection to search.
         * </p>
         * 
         * @param collectionId
         *        ID of the collection to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * 
         * @param image
         *        The input image as bytes or an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().apply(image).build());
        }

        /**
         * <p>
         * Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         * confidence in the match.
         * </p>
         * 
         * @param maxFaces
         *        Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         *        confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFaces(Integer maxFaces);

        /**
         * <p>
         * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
         * matches where confidence in matches is less than 70%.
         * </p>
         * 
         * @param faceMatchThreshold
         *        (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
         *        matches where confidence in matches is less than 70%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatchThreshold(Float faceMatchThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private Integer maxFaces;

        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageRequest model) {
            collectionId(model.collectionId);
            image(model.image);
            maxFaces(model.maxFaces);
            faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxFaces() {
            return maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public SearchFacesByImageRequest build() {
            return new SearchFacesByImageRequest(this);
        }
    }
}
