/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompareFacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompareFacesRequest> {
    private final Image sourceImage;
    private final Image targetImage;
    private final Float similarityThreshold;

    private CompareFacesRequest(BuilderImpl builder) {
        this.sourceImage = builder.sourceImage;
        this.targetImage = builder.targetImage;
        this.similarityThreshold = builder.similarityThreshold;
    }

    public Image sourceImage() {
        return this.sourceImage;
    }

    public Image targetImage() {
        return this.targetImage;
    }

    public Float similarityThreshold() {
        return this.similarityThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.similarityThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesRequest)) {
            return false;
        }
        CompareFacesRequest other = (CompareFacesRequest)((Object)obj);
        return Objects.equals(this.sourceImage(), other.sourceImage()) && Objects.equals(this.targetImage(), other.targetImage()) && Objects.equals(this.similarityThreshold(), other.similarityThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceImage() != null) {
            sb.append("SourceImage: ").append(this.sourceImage()).append(",");
        }
        if (this.targetImage() != null) {
            sb.append("TargetImage: ").append(this.targetImage()).append(",");
        }
        if (this.similarityThreshold() != null) {
            sb.append("SimilarityThreshold: ").append(this.similarityThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceImage": {
                return Optional.of(clazz.cast(this.sourceImage()));
            }
            case "TargetImage": {
                return Optional.of(clazz.cast(this.targetImage()));
            }
            case "SimilarityThreshold": {
                return Optional.of(clazz.cast(this.similarityThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Image sourceImage;
        private Image targetImage;
        private Float similarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesRequest model) {
            this.sourceImage(model.sourceImage);
            this.targetImage(model.targetImage);
            this.similarityThreshold(model.similarityThreshold);
        }

        public final Image.Builder getSourceImage() {
            return this.sourceImage != null ? this.sourceImage.toBuilder() : null;
        }

        @Override
        public final Builder sourceImage(Image sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final void setSourceImage(Image.BuilderImpl sourceImage) {
            this.sourceImage = sourceImage != null ? sourceImage.build() : null;
        }

        public final Image.Builder getTargetImage() {
            return this.targetImage != null ? this.targetImage.toBuilder() : null;
        }

        @Override
        public final Builder targetImage(Image targetImage) {
            this.targetImage = targetImage;
            return this;
        }

        public final void setTargetImage(Image.BuilderImpl targetImage) {
            this.targetImage = targetImage != null ? targetImage.build() : null;
        }

        public final Float getSimilarityThreshold() {
            return this.similarityThreshold;
        }

        @Override
        public final Builder similarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public final void setSimilarityThreshold(Float similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
        }

        public CompareFacesRequest build() {
            return new CompareFacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompareFacesRequest> {
        public Builder sourceImage(Image var1);

        default public Builder sourceImage(Consumer<Image.Builder> sourceImage) {
            return this.sourceImage((Image)((Image.Builder)Image.builder().apply(sourceImage)).build());
        }

        public Builder targetImage(Image var1);

        default public Builder targetImage(Consumer<Image.Builder> targetImage) {
            return this.targetImage((Image)((Image.Builder)Image.builder().apply(targetImage)).build());
        }

        public Builder similarityThreshold(Float var1);
    }
}

