/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCollectionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateCollectionResponse> {
    private final Integer statusCode;
    private final String collectionArn;

    private CreateCollectionResponse(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.collectionArn = builder.collectionArn;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public String collectionArn() {
        return this.collectionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionResponse)) {
            return false;
        }
        CreateCollectionResponse other = (CreateCollectionResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.collectionArn(), other.collectionArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.collectionArn() != null) {
            sb.append("CollectionArn: ").append(this.collectionArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusCode": {
                return Optional.of(clazz.cast(this.statusCode()));
            }
            case "CollectionArn": {
                return Optional.of(clazz.cast(this.collectionArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer statusCode;
        private String collectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionResponse model) {
            this.statusCode(model.statusCode);
            this.collectionArn(model.collectionArn);
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getCollectionArn() {
            return this.collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        public CreateCollectionResponse build() {
            return new CreateCollectionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCollectionResponse> {
        public Builder statusCode(Integer var1);

        public Builder collectionArn(String var1);
    }
}

