/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectModerationLabelsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetectModerationLabelsRequest> {
    private final Image image;
    private final Float minConfidence;

    private DetectModerationLabelsRequest(BuilderImpl builder) {
        this.image = builder.image;
        this.minConfidence = builder.minConfidence;
    }

    public Image image() {
        return this.image;
    }

    public Float minConfidence() {
        return this.minConfidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsRequest)) {
            return false;
        }
        DetectModerationLabelsRequest other = (DetectModerationLabelsRequest)((Object)obj);
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.minConfidence(), other.minConfidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.minConfidence() != null) {
            sb.append("MinConfidence: ").append(this.minConfidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "MinConfidence": {
                return Optional.of(clazz.cast(this.minConfidence()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Image image;
        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsRequest model) {
            this.image(model.image);
            this.minConfidence(model.minConfidence);
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        public DetectModerationLabelsRequest build() {
            return new DetectModerationLabelsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectModerationLabelsRequest> {
        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().apply(image)).build());
        }

        public Builder minConfidence(Float var1);
    }
}

