/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.EmotionName;
import software.amazon.awssdk.services.rekognition.transform.EmotionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Emotion
implements StructuredPojo,
ToCopyableBuilder<Builder, Emotion> {
    private final String type;
    private final Float confidence;

    private Emotion(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
    }

    public EmotionName type() {
        return EmotionName.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Emotion)) {
            return false;
        }
        Emotion other = (Emotion)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.confidence(), other.confidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Confidence": {
                return Optional.of(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmotionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Emotion model) {
            this.type(model.type);
            this.confidence(model.confidence);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EmotionName type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public Emotion build() {
            return new Emotion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Emotion> {
        public Builder type(String var1);

        public Builder type(EmotionName var1);

        public Builder confidence(Float var1);
    }
}

